IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Cliente_Ref_Borrar]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Cliente_Ref_Borrar]
END
GO

CREATE PROCEDURE [dbo].[CP_Cliente_Ref_Borrar] @Int INT,@Tit INT
AS

DECLARE @MensajeFinEjec		VARCHAR(100)

IF @Int = 0 
BEGIN
	SELECT 1, 0, 0, 0, 'El cliente no puede ser 0 (cero)'
	RETURN
END

IF @Tit = 0
BEGIN
	SELECT 1, 0, 0, 0, 'El cliente de referencia no puede ser 0 (cero)'
	RETURN
END


BEGIN TRY
	BEGIN TRAN

	SET @MensajeFinEjec = 'Proceso Exitoso'

	IF CAST(dbo.CF_xParam('Cli_Ref_CtaCte_Agrup') as INT ) <> 0
	BEGIN
	    UPDATE Cbtes SET Id_Cliente_Ref =  @Tit 
		             WHERE Id_Cliente = @Int 
					 AND ISNULL(Id_Cliente,0) = 0
				     AND Id_estado_Cbte <> 1
	  
	    --actualizo los items que no tienen id_cliente
		UPDATE Cbtes_Items SET Id_Cliente = @Int
				FROM Cbtes C, Cbtes_Items I
				WHERE I.Id_Trans = C.Id_Trans
				AND ISNULL(I.id_Cliente,0) = 0
				AND C.Id_Cliente =  @Int 

		UPDATE Cbtes_Items SET Id_Cliente = @Tit
				FROM Cbtes C, Cbtes_Items I
				WHERE I.Id_Trans = C.Id_Trans
				AND ISNULL(I.id_Cliente,0) = 0
				AND C.Id_Cliente =  @Tit 
		--FIN: actualizo los items que no tienen id_cliente

		--todo lo que no esta pendiente queda en el titular
		UPDATE Cbtes SET Id_Cliente = @Tit
										--se agrega left para editar el error por truncado 
		               , Destinatario = LEFT (LTRIM(RTRIM(Destinatario)) + ' - ' + LTRIM(RTRIM(E.Razon_Social)),100)
					   , Id_Cliente_Ref = @Tit
				FROM Cbtes C,Clientes E
				WHERE E.Id_Cliente =  @Tit
				AND C.Id_Cliente =  @Int 
				AND C.ID_ESTADO_CBTE <> 1


		UPDATE Clientes_CtaCte SET Id_Cliente = C.Id_cliente  from Clientes_CtaCte K, Cbtes C
		WHERE c.id_trans = k.id_trans  and K.id_cliente = @int and C.id_cliente <> K.id_cliente

		UPDATE Clientes_CtaCte SET Id_Cliente = C.Id_cliente  from Clientes_CtaCte K, Cbtes C
		WHERE c.id_trans = k.id_trans  and K.id_cliente = @Tit and C.id_cliente <> K.id_cliente
		      
	END

	UPDATE Clientes SET Id_Cliente_Ref = 0 WHERE Id_Cliente = @Int
	----------------------------------------------------
	COMMIT
	
	SELECT 0, 0, 0, 0, @MensajeFinEjec
END TRY

BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH